;Constant map from the NSF.  The last four constants for the lights are
;globals that should be updated by the application.  Exponent and WarpAlpha
;are attributes that hang off the object.
;
;WorldViewProjTranspose  0       0
;InvViewTranspose        4       0
;NormalUVs				 7		 0
;WorldTranspose          8       0
;Eye Position            12   1  0.0, 0.0, 0.0, 1.0
;BumpScale               11   1  0

;AmbLightColor           14
;MaterialAmbient         15
;MaterialDiffuse         16

xvs.1.1

;PDP_Position    0
;PDP_Normal      1
;PDP_TexCoord0   2
;PDP_Binormal    3
;PDP_Tangent     4

m4x4 oPos, v0, c0            ;Tranform and emit to oPos for optimization

add r1, c7, v2
mov oT0, r1
                             
;We need to scale the binormal and tangent vectors before we calculate the
;composite matrix to store in oT1, oT2, and oT3.  That matrix must take the 
;tangent space normals into world space to match our cube map.  It is the
;composite of the tangent to object matrix and the object to world matrix.
;Since the components of the tangent to object matrix map to N, B, and T, if
;we scale B and T to zero before creating the matrix then we only extract the
;component of the normal map that is normal to the actual surface of the 
;geometry.  The result is a smooth, mirror-reflective environment map.
mul  r11, c13.x, v4          
mul  r10, c13.x, v3

dp3  oT1.x, r11, c8
dp3  oT1.y, r10, c8
dp3  oT1.z, v1, c8

dp3  oT2.x, r11, c9
dp3  oT2.y, r10, c9
dp3  oT2.z, v1, c9

dp3  oT3.x, r11, c10
dp3  oT3.y, r10, c10
dp3  oT3.z, v1, c10

;We need the eye vector in world space to work with the texm3x3vspec instruction
;in the pixel shader.
m4x4 r1, v0, c8             ;Transform position to world space.
mov  r3, c12
m4x4 r2, r3, c4             ;Move eye into world space.

add  r2, r2, -r1

;The texm3x3vspec instruction expects the eye vector in the w components.
mov oT1.w, r2.x
mov oT2.w, r2.y
mov oT3.w, r2.z

;Ambient Lighting - rest will be done in ps
mov oD1, c14                 ;Move in color so we can use in PS

